/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.custom.components;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.mixin.client.network.INetHandlerPlayClientMixin;
import noppes.npcs.api.wrapper.gui.CustomGuiEntityWrapper;
import noppes.npcs.client.gui.custom.GuiCustom;
import noppes.npcs.client.gui.custom.interfaces.IGuiComponent;
import noppes.npcs.controllers.PlayerSkinController;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.Util;

public class CustomGuiEntity
extends Gui
implements IGuiComponent {
    int id;
    int x;
    int y;
    int width = 53;
    int height = 70;
    int rotType;
    int rotYaw;
    int rotPitch;
    long initTime = System.currentTimeMillis();
    boolean hasBorder;
    boolean showArmor;
    String[] hoverText;
    IItemStack hoverStack;
    GuiCustom parent;
    float scale;
    final int[] offsets;
    NBTTagCompound entityNbt;
    public Entity entity;

    public static CustomGuiEntity fromComponent(CustomGuiEntityWrapper component) {
        CustomGuiEntity entt = new CustomGuiEntity(component.getId(), component.getPosX(), component.getPosY(), component.getScale(), component.hasBorder(), component.isShowArmorAndItems(), component.entityNbt, component.rotType, component.rotYaw, component.rotPitch);
        if (component.hasHoverText()) {
            entt.hoverText = component.getHoverText();
            entt.hoverStack = component.getHoverStack();
        }
        return entt;
    }

    public CustomGuiEntity(int id, int x, int y, float scale, boolean hasBorder, boolean showArmor, NBTTagCompound entityNbt, int rotType, int rotYaw, int rotPitch) {
        this.id = id;
        this.x = GuiCustom.guiLeft + x;
        this.y = GuiCustom.guiTop + y;
        this.scale = scale;
        this.hasBorder = hasBorder;
        this.showArmor = showArmor;
        this.offsets = new int[]{0, 0};
        this.entityNbt = entityNbt;
        this.rotType = rotType;
        this.rotYaw = rotYaw;
        this.rotPitch = rotPitch;
    }

    private void createEntity(Minecraft mc) {
        if (this.entityNbt.func_74767_n("IsPlayer")) {
            EntityEquipmentSlot[] npc = (EntityEquipmentSlot[])EntityList.func_188429_b((ResourceLocation)new ResourceLocation("customnpcs", "customnpc"), (World)mc.field_71441_e);
            if (npc instanceof EntityCustomNpc) {
                ((EntityCustomNpc)npc).modelData.eyes.type = (byte)-1;
                UUID uuid = this.entityNbt.func_186857_a("UUID");
                if (this.entityNbt.func_150297_b("SkinData", 10)) {
                    NBTTagList list = this.entityNbt.func_74775_l("SkinData").func_150295_c("Textures", 10);
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        NBTTagCompound nbtSkin = list.func_150305_b(i);
                        if (nbtSkin.func_74779_i("Type").equalsIgnoreCase("SKIN")) {
                            npc.display.setSkinTexture(nbtSkin.func_74779_i("Location"));
                        }
                        if (!nbtSkin.func_74779_i("Type").equalsIgnoreCase("CAPE")) continue;
                        npc.display.setCapeTexture(nbtSkin.func_74779_i("Location"));
                    }
                } else if (PlayerSkinController.getInstance().playerTextures.containsKey(uuid)) {
                    Map<MinecraftProfileTexture.Type, ResourceLocation> data = PlayerSkinController.getInstance().getData(uuid);
                    if (data != null) {
                        if (data.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                            npc.display.setSkinTexture(data.get(MinecraftProfileTexture.Type.SKIN).toString());
                        }
                        if (data.containsKey(MinecraftProfileTexture.Type.CAPE)) {
                            npc.display.setCapeTexture(data.get(MinecraftProfileTexture.Type.CAPE).toString());
                        }
                    }
                } else {
                    Map<UUID, NetworkPlayerInfo> playerInfoMap;
                    NetHandlerPlayClient netHandler = Minecraft.func_71410_x().func_147114_u();
                    if (netHandler != null && (playerInfoMap = ((INetHandlerPlayClientMixin)netHandler).npcs$getplayerInfoMap()).containsKey(uuid)) {
                        NetworkPlayerInfo npi = playerInfoMap.get(uuid);
                        npi.func_178837_g();
                        npc.display.setSkinTexture(npi.func_178837_g().toString());
                        if (npi.func_178861_h() != null) {
                            npc.display.setCapeTexture(npi.func_178861_h().toString());
                        }
                    }
                }
                if (this.showArmor) {
                    NBTTagList inv = this.entityNbt.func_150295_c("Inventory", 10);
                    int mainStackSlot = this.entityNbt.func_74762_e("SelectedItemSlot");
                    for (int i = 0; i < inv.func_74745_c(); ++i) {
                        NBTTagCompound nbtSlotStack = inv.func_150305_b(i);
                        if (nbtSlotStack.func_74771_c("Slot") == 100) {
                            npc.inventory.armor.put(3, Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(new ItemStack(nbtSlotStack)));
                        }
                        if (nbtSlotStack.func_74771_c("Slot") == 101) {
                            npc.inventory.armor.put(2, Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(new ItemStack(nbtSlotStack)));
                        }
                        if (nbtSlotStack.func_74771_c("Slot") == 102) {
                            npc.inventory.armor.put(1, Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(new ItemStack(nbtSlotStack)));
                        }
                        if (nbtSlotStack.func_74771_c("Slot") == 103) {
                            npc.inventory.armor.put(0, Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(new ItemStack(nbtSlotStack)));
                        }
                        if (nbtSlotStack.func_74771_c("Slot") == mainStackSlot) {
                            npc.inventory.weapons.put(0, Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(new ItemStack(nbtSlotStack)));
                        }
                        if (nbtSlotStack.func_74771_c("Slot") != -106 && nbtSlotStack.func_74771_c("Slot") != 106) continue;
                        npc.inventory.weapons.put(2, Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(new ItemStack(nbtSlotStack)));
                    }
                }
                this.entity = Util.instance.copyToGUI((EntityNPCInterface)npc, (World)mc.field_71441_e, false);
            }
        } else {
            this.entity = EntityList.func_75615_a((NBTTagCompound)this.entityNbt, (World)mc.field_71441_e);
            if (this.entity != null) {
                this.entity.field_70177_z = 0.0f;
                this.entity.field_70126_B = 0.0f;
                this.entity.func_70034_d(0.0f);
                this.entity.field_70125_A = 0.0f;
                this.entity.field_70127_C = 0.0f;
                if (!this.showArmor) {
                    for (EntityEquipmentSlot ees : EntityEquipmentSlot.values()) {
                        this.entity.func_184201_a(ees, ItemStack.field_190927_a);
                    }
                }
            }
        }
        if (this.entity instanceof EntityNPCInterface) {
            this.entity = Util.instance.copyToGUI((EntityNPCInterface)this.entity, (World)mc.field_71441_e, false);
            String skin = ((EntityNPCInterface)this.entity).display.getSkinTexture();
            if (skin.equals("minecraft:textures/entity/alex.png") || skin.toLowerCase().contains("alex") || skin.toLowerCase().contains("/female")) {
                ((EntityNPCInterface)this.entity).display.setModel("customnpcs:customnpcalex");
            }
        }
    }

    private void drawEntity(Minecraft mc, int mouseX, int mouseY) {
        float f6;
        float f5;
        EntityNPCInterface npc = null;
        if (this.entity instanceof EntityNPCInterface) {
            npc = (EntityNPCInterface)this.entity;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)this.x + 26.5f * this.scale), (float)((float)this.y + 65.0f * this.scale), (float)350.0f);
        if ((double)this.entity.field_70131_O > 2.4) {
            this.scale = 2.0f / this.entity.field_70131_O;
        }
        GlStateManager.func_179152_a((float)(-30.0f * this.scale), (float)(30.0f * this.scale), (float)(30.0f * this.scale));
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderHelper.func_74519_b();
        float f2 = this.entity instanceof EntityLivingBase ? ((EntityLivingBase)this.entity).field_70761_aq : this.entity.field_70177_z;
        float f3 = this.entity.field_70177_z;
        float f4 = this.entity.field_70125_A;
        float f = f5 = this.entity instanceof EntityLivingBase ? ((EntityLivingBase)this.entity).field_70759_as : this.entity.field_70177_z;
        float f7 = this.rotType == 0 ? 0.0f : (f6 = this.rotType == 1 ? (float)this.x + 26.5f * this.scale - (float)mouseX : (float)this.rotYaw);
        float f72 = this.rotType == 0 ? 0.0f : (this.rotType == 1 ? (float)this.y + (15.0f + this.scale) - (float)mouseY : (float)this.rotPitch);
        int orientation = 0;
        if (npc != null) {
            orientation = npc.ais.orientation;
            npc.ais.orientation = 0;
        }
        if (this.rotType == 1) {
            GlStateManager.func_179114_b((float)((float)(-Math.atan(f6 / 400.0f) * 20.0)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(-Math.atan(f72 / 40.0f) * 20.0)), (float)1.0f, (float)0.0f, (float)0.0f);
            this.entity.field_70177_z = (float)(Math.atan(f6 / 80.0f) * 40.0 + 0.0);
            this.entity.field_70125_A = (float)(-Math.atan(f72 / 40.0f) * 20.0);
        } else if (this.rotType == 2) {
            GlStateManager.func_179114_b((float)f6, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)f72, (float)1.0f, (float)0.0f, (float)0.0f);
            this.entity.field_70177_z = f6;
            this.entity.field_70125_A = f72;
        }
        if (this.entity instanceof EntityLivingBase) {
            ((EntityLivingBase)this.entity).field_70761_aq = this.rotType == 2 ? f6 : 0.0f;
            ((EntityLivingBase)this.entity).field_70759_as = this.entity.field_70177_z;
        }
        mc.func_175598_ae().field_78735_i = 180.0f;
        mc.func_175598_ae().func_188391_a(this.entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        if (this.entity instanceof EntityLivingBase) {
            ((EntityLivingBase)this.entity).field_70761_aq = f2;
            ((EntityLivingBase)this.entity).field_70760_ar = f2;
        }
        this.entity.field_70177_z = f3;
        this.entity.field_70126_B = f3;
        this.entity.field_70125_A = f4;
        this.entity.field_70127_C = f4;
        if (this.entity instanceof EntityLivingBase) {
            ((EntityLivingBase)this.entity).field_70759_as = f5;
            ((EntityLivingBase)this.entity).field_70758_at = f5;
        }
        if (npc != null) {
            npc.ais.orientation = orientation;
        }
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int[] getPosXY() {
        return new int[]{this.x, this.y};
    }

    @Override
    public void offSet(int offsetType, double[] windowSize) {
        switch (offsetType) {
            case 1: {
                this.offsets[0] = 0;
                this.offsets[1] = (int)windowSize[1];
                break;
            }
            case 2: {
                this.offsets[0] = (int)windowSize[0];
                this.offsets[1] = 0;
                break;
            }
            case 3: {
                this.offsets[0] = (int)windowSize[0];
                this.offsets[1] = (int)windowSize[1];
                break;
            }
            default: {
                this.offsets[0] = 0;
                this.offsets[1] = 0;
            }
        }
    }

    @Override
    public void onRender(Minecraft mc, int mouseX, int mouseY, int mouseWheel, float partialTicks) {
        boolean hovered;
        if (this.entity == null && (this.entityNbt == null || this.entityNbt.func_150296_c().isEmpty())) {
            return;
        }
        boolean bl = hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
        if (this.hasBorder) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.x, (float)this.y, (float)0.0f);
            GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)0.0f);
            this.func_73733_a(-1, -1, this.width + 1, this.height + 1, -8355712, -8355712);
            this.func_73733_a(0, 0, this.width, this.height, -16777216, -16777216);
            GlStateManager.func_179121_F();
        }
        if (this.entity == null) {
            this.createEntity(mc);
        }
        if (this.entity != null) {
            this.entity.field_70173_aa = (int)((System.currentTimeMillis() - this.initTime) / 50L);
            this.entity.func_70071_h_();
            GlStateManager.func_179094_E();
            this.drawEntity(mc, mouseX, mouseY);
            GlStateManager.func_179121_F();
        }
        if (hovered) {
            if (this.hoverText != null && this.hoverText.length > 0) {
                this.parent.hoverText = this.hoverText;
            }
            if (this.hoverStack != null && !this.hoverStack.isEmpty()) {
                this.parent.hoverStack = this.hoverStack.getMCItemStack();
            }
        }
    }

    @Override
    public void setParent(GuiCustom gui) {
        this.parent = gui;
    }

    @Override
    public void setPosXY(int newX, int newY) {
        this.x = newX;
        this.y = newY;
    }

    @Override
    public ICustomGuiComponent toComponent() {
        CustomGuiEntityWrapper component = new CustomGuiEntityWrapper(this.id, this.x, this.y, Objects.requireNonNull(NpcAPI.Instance()).getIEntity(this.entity));
        component.entityNbt = this.entityNbt;
        component.setHoverText(this.hoverText);
        return component;
    }
}

